//AIM:Design of IIR filter.
//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
//We will compute the order and the poles of Butterworth low pass filter 
//using bilinear transformation(Asuming T= 1 sec);
s=poly(0,"s")
T=1;
Ap=0.8;//Attenuation in pass band
As=0.2;//Attenuation in stop band
wp=0.2*(%pi)
ws=0.6*(%pi)
ohmp=2/T*(tan(wp/2))
ohms=2/T*(tan(ws/2))
//ORDER CALCULATION(N);
a=(1/As^2-1)
b=(1/Ap^2-1)
c=log(a/b)
N=(1/2)*(c/(log(ohms/ohmp)))
Nr=int (N)
x=N-int(N)
if(x>0)
 Nr=Nr+1 
else
   Nr=N
   end   
ohmc=(ohmp/(1/Ap^2-1)^(1/(2*Nr)))
//calculation of poles
i=0:1:Nr-1;
pi_plus=ohmc*exp(%i*(Nr+2*i+1)*(%pi)/(2*Nr))
pi_minus=-ohmc*exp(%i*(2+2.*i+1)*(%pi)/(2*Nr))
disp(wp,'wp=')
disp(ws,'ws=')
disp(ohmp,'ohmp=')
disp(ohms,'ohms=')
disp(N,'N=')
disp(Nr,'The value of N after round-off i.e. Nr=')
disp(ohmc,'ohmc=')
disp(pi_plus,'Poles=')
disp(pi_minus,'Poles=')
h2=zeros(1,2)
h=ohmc/(s-(-0.53-0.53*%i))
h1=ohmc/(s-(-0.53+0.53*%i))
h2=h*h1;
disp(h,'H1(s)=');
disp(h1,'H2(s)=');
disp('As H(s)=H1(s)*H2(s)')
disp(h2,'So, H(s)=');
// To obtaining transfer function for digital fillter
Z=poly(0,"Z")
s=(2/T)*((Z-1)/(Z+1));
Z1=0.56/(s^2+1.06*s+0.56);
disp(Z1,"Transfer function of Digital filter H(Z)=")

//Expected output: Transfer function of the digital filter 
//H(z)=(0.56+1.12Z+0.56Z^2)/(2.44 - 6.88Z + 6.68Z^2)   
   
